// $Id: RegexPattern.h 1370 2025-02-18 20:04:05Z ge $
// Copyright 2024 Gerald Weber
/// \file Nucleotide.h
/// \brief Contains the definition of the class Nucleotide
///
/// $Revision: 1370 $
/// \author Gerald Weber <gweberbh@gmail.com>
#ifndef GBC_REGEXPATTERN_H
#define GBC_REGEXPATTERN_H "$Id: RegexPattern.h 1370 2025-02-18 20:04:05Z ge $"

//Nucleotide.h
#define NUCLEOTIDE_STRING_INTERPRETATION_PATTERN "([a-z]?)([a-zA-Z_])"
//BasePair 
#define BASEPAIR_STRING_INTERPRETATION_PATTERN "([a-z]?[a-zA-Z_])([a-z]?[a-zA-Z_])\\^?(.*)"
//BasePairNeighbours
#define BASEPAIRNEIGHBOURS_BPN2BP1_PATTERN "(.*)_(.*)"
#define BASEPAIRNEIGHBOURS_BPN2BP2_PATTERN "(.*)_(.*)"
//Duplex 
#define DUPLEX_SET_DUPLEX_PATTERN "([^/]+)/(.+)"
//NucleotideSequence 
#define NUCLEOTIDESEQUENCE_ASSIGN_PATTERN "([35]?)([a-z]?)\\((.+)\\)"
#define NUCLEOTIDESEQUENCE_SPLIT_PATTERN "(\\<[a-z][A-Z]\\>|[a-zA-Z])"
#define NUCLEOTIDESEQUENCE_SUGAR_PATTERN "([a-z])([A-Z])"
//StrandPair.h 
#define STRANDPAIR_ASSIGN_PATTERN "(.)([<>])(.)"
//SequenceDataset.h
#define SEQUENCEDATASET_BP_MATCH_PATTERN "^\\+([^ ]+?)\\s"
#define SEQUENCEDATASET_EQUIV_MATCH_PATTERN "^\\+[^ ]+?\\s+(.*)$"

#endif
