#!/bin/bash
#uses parameters for PEG
set -e
if [ -z $PREFIX ]; then export PREFIX=../data; fi
if [ -z $BIN ]; then export BIN=tfreg; fi

export COMMON="-cutoff=10 -int=-1:200/400 -m=pb -pbc=0 -pm=2 -t=370 -v=1 -printusedpar"

export WD=verify-peg
mkdir -p $WD


$BIN $COMMON -res=regression -data=$PREFIX/ghosh20.dat -par=$PREFIX/dna_pb_peg_122.par -o=$WD/verify-dd-peg

$BIN $COMMON -res=regression -expand=dCrG_dCrG -data=$PREFIX/banerjee23.dat -par=$PREFIX/rna-dna-pb-peg-122.par -o=$WD/verify-dr-peg

$BIN $COMMON -res=regression -data=$PREFIX/ghosh23.dat -par=$PREFIX/rna_pb_peg_122.par -o=$WD/verify-rr-peg
