// $Id: TestModel.h 981 2017-11-01 17:03:51Z ge $
/// \file TestModel.h
/// \brief contains the classes which are can be modifies by users
///
/// $Revision: 981 $
/// \author Gerald Weber <gweberbh@gmail.com>
#ifndef GBC_TESTMODEL_H
#define GBC_TESTMODEL_H "$Id: TestModel.h 981 2017-11-01 17:03:51Z ge $"
#include <valarray>
#include "BasePairNeighbours.h"
#include "Hamiltonian.h"
namespace gbc
  {
  template<class _Tp=double>
  /// \brief Test base-pair potential
  ///
  /// Generic potential V(x) which you can modify to suit your needs
  class TestVx: public BasePotential<_Tp>
    {
    public:
      typedef BasePotential<_Tp> base_type;
      typedef typename base_type::parameter_map_type parameter_map_type;
      typedef _Tp value_type;
      typedef std::valarray<value_type> vector_type;

      BasePair<> bp;
      
      // Here we define the parameters a to h
      value_type a; 
      value_type b;
      value_type c;
      value_type d;
      value_type e;
      value_type f; 
      value_type g;
      value_type h;


    TestVx(void) : a(), b(), c(), d(), e(), f(), g(), h() 
      {
      base_type::name("test_vx");
      base_type::prefix(std::string());
      }

    TestVx(const BasePair<>& b) : bp(b), a(), b(), c(), d(), e(), f(), g(), h() 
      {
      base_type::name("test_vx");
      bp.reduce_to_smallest_symmetry();
      base_type::prefix((std::string)bp);
      }

    /// \brief Retrieve the parameter from the map
    inline virtual bool get_parameters(parameter_map_type& pm)
      {
      this->define_parameter(pm,"a",a);
      this->define_parameter(pm,"b",b);
      this->define_parameter(pm,"c",c);
      this->define_parameter(pm,"d",d);
      this->define_parameter(pm,"e",e);
      this->define_parameter(pm,"f",f);
      this->define_parameter(pm,"g",g);
      this->define_parameter(pm,"h",h);
      return true;
      }

    inline bool parameters(const TestVx<value_type>& test)
      {
      bool modified=(a != test.a) || (b != test.b) || (c != test.c) || (d != test.d)|| 
                    (e != test.e) || (f != test.f) || (g != test.g) || (h != test.h);
      a=test.a; b=test.b;  c=test.c; d=test.d; 
      e=test.e; f=test.f;  g=test.g; h=test.h; 
      return modified;
      }

    inline virtual value_type evaluate_xy(value_type x, value_type y=value_type()) const
      {
      // Insert your expression here, you may use the parameters a to h 
      // DO NOT USE VARIABLE y as this will always be set to zero
      // In you parameter file (extension .par) define these parameters as
      // AT:test_vx.a 0.3
      // CG:test_vx.b 2.5
      return x*(a+b+c+d+e+f+g+h); // MODIFY HERE
      }
    };
    

  template<class _Tp=double>
  class TestWxy: public BasePotential<_Tp>
    {
    public:
      typedef BasePotential<_Tp> base_type;
      typedef typename base_type::parameter_map_type parameter_map_type;
      typedef _Tp value_type;
      typedef std::valarray<value_type> vector_type;

      BasePairNeighbours<> bpn;
       // Here we define the parameters a to h
      value_type a; 
      value_type b;
      value_type c;
      value_type d;
      value_type e;
      value_type f; 
      value_type g;
      value_type h;

    TestWxy(void) : a(), b(), c(), d(), e(), f(), g(), h() 
      {
      base_type::name("test_wxy");
      base_type::prefix(std::string());
      }

    TestWxy(const BasePairNeighbours<>& b) : bpn(b), a(), b(), c(), d(), e(), f(), g(), h() 
      {
      base_type::name("test_wxy");
      bpn.reduce_to_smallest_symmetry();
      base_type::prefix((std::string)bpn);
      }

    inline virtual bool get_parameters(parameter_map_type& pm)
      {
      this->define_parameter(pm,"a",a);
      this->define_parameter(pm,"b",b);
      this->define_parameter(pm,"c",c);
      this->define_parameter(pm,"d",d);
      this->define_parameter(pm,"e",e);
      this->define_parameter(pm,"f",f);
      this->define_parameter(pm,"g",g);
      this->define_parameter(pm,"h",h);
      return true;
      }

    inline bool parameters(const TestWxy<value_type>& test)
      {
      bool modified=(a != test.a) || (b != test.b) || (c != test.c) || (d != test.d)|| 
                    (e != test.e) || (f != test.f) || (g != test.g) || (h != test.h);
      a=test.a; b=test.b;  c=test.c; d=test.d; 
      e=test.e; f=test.f;  g=test.g; h=test.h; 
      return modified;
      }

    inline virtual value_type evaluate_xy(value_type x, value_type y=value_type()) const
      {
      // Insert your expression here, you may use the parameters a to h
      // In you parameter file (extension .par) define these parameters as
      // AT_AT:test_wxy.a 0.3
      // CG_CG:test_wxy.b 2.5
      return x*y*(a+b+c+d+e+f+g+h); // MODIFY HERE
      }

    };
    
  // If you would like to test a different combination of potentials replace
  // TestVx with Morse, Solvent, or MorseSolvent
  // TestWxy with HarmonicStacking, AnharmonicStacking, ExactStacking, or FiniteEnthalpyStacking

  template<class _Tp=double>
  class TestHamiltonian: public Hamiltonian<TestVx<_Tp>,TestWxy<_Tp> >
//                                          ^^^^^^      ^^^^^^^ Replace TestVx and/or TestWxy
    {
    public: 
      typedef _Tp value_type;
      typedef Hamiltonian<TestVx<_Tp>,TestWxy<_Tp> > base_type;
//                        ^^^^^^      ^^^^^^^ Replace TestVx and/or TestWxy

    TestHamiltonian(void): base_type() {}

    TestHamiltonian(const BasePairNeighbours<>& stk)
      : base_type(stk) {}

    };

    
  };

#endif
