// $Id: Nucleotide.cpp 1115 2020-05-04 17:42:39Z ge $
/// \file Nucleotide.cpp
/// \brief contains the static initialization of the dictionaries used.
///
/// The predefined dictionaries are for NucleotideDictionary<char>,
/// NucleotideDictionary<int>, NucleotideDictionary<complex<int> >
/// and NucleotideDictionary<BinaryIndicator>.
///
/// $Revision: 1.9 $
/// \author Gerald Weber <gweberbh@gmail.com>
#define GBC_NUCLEOTIDE_CPP "$Id: Nucleotide.cpp 1115 2020-05-04 17:42:39Z ge $"
#include "Nucleotide.h"

using namespace gbc;
using namespace std;

namespace gbc
{

template<> NucleotideDictionary<char,char>
  Nucleotide<char,char>::dictionary(NucleotideCode::DNA);

template<> NucleotideDictionary<int,char>
  Nucleotide<int,char>::dictionary(NucleotideCode::DNA);

template<> NucleotideDictionary<short int,char>
  Nucleotide<short int,char>::dictionary(0,1,2,3,4);

template<> NucleotideDictionary<unsigned int,char>
  Nucleotide<unsigned int,char>::dictionary(0U,1U,2U,3U,4U);


template<> NucleotideDictionary<unsigned short int,char>
  Nucleotide<unsigned short int,char>::dictionary(0U,1U,2U,3U,4U);

#if __GNUC__ >= 3
#include <complex>
template<> NucleotideDictionary<complex<int>,char>
  Nucleotide<complex<int>,char>::dictionary(complex<int>( 0, 0), /* # */
                                            complex<int>( 1, 1), /* A */
                                            complex<int>(-1,-1), /* C */
					    complex<int>(-1, 1), /* G */
					    complex<int>( 1,-1)  /* T */);
#endif

//   template<> NucleotideDictionary<std::string,std::string>::DictionaryType
//    Nucleotide<std::string,std::string>::dictionary(true);
 
//  template<> NucleotideDictionary<std::string,std::string>
//    Nucleotide<std::string,std::string>::dictionary(std::string("#"),std::string("A"),std::string("C"),std::string("G"),std::string("T"));
  
  
};
