// $Id: RegexAux.h 1302 2022-03-22 16:52:19Z ge $
/// \file RegexAux.h
/// \brief contains auxiliary regular expression functions
///
/// $Revision: 1302 $
/// \author Gerald Weber <gweberbh@gmail.com>
#ifndef GBC_REGEXAUX_H
#define GBC_REGEXAUX_H "$Id: RegexAux.h 1302 2022-03-22 16:52:19Z ge $"

#include <algorithm>
#include <boost/regex.hpp>
#include <string>

inline double assign(double &temp, std::string found)
  {
  temp=std::atof(found.c_str());
  return temp;
  }
  
inline int assign(int &temp, std::string found)
  {
  temp=std::atoi(found.c_str());
  return temp;
  }
  
inline std::string reverse(std::string st)
  {
  std::string rev=st;
  std::reverse(rev.begin(), rev.end());
  return rev;
  }
  
  
inline bool reg_match(std::string target, std::string pat)
  {
  boost::regex pattern(pat);
  boost::smatch what;
  return boost::regex_search(target,what,pattern);
  }
  
    
inline std::string reg_match_string(const std::string target, std::string pat, int pos=1) //pos->submatch, to match the whole pattern use pos=0
  {
  boost::regex pattern(pat);
  boost::smatch what;
  if (boost::regex_search(target,what,pattern))  return what[pos];
  else return std::string();
  }

inline std::string reg_match_string(const std::string &target, boost::regex &pat, int pos=1)
  {
  boost::smatch what;
  if (boost::regex_search(target,what,pat))  return what[pos];
  else return std::string();
  }
  
inline std::string reg_rm_white_space(const std::string target)
  {
  return boost::regex_replace(target,boost::regex("\\s"),"",boost::format_all);
  }
  
#endif
