#!/bin/bash
#calculates the average displacements for the sequences of spiriti11
if [ -z $BIN ]; then export BIN=tfreg; fi
if [ -z $PREFIX ]; then export PREFIX=../data; fi
export COMMON="-matrix=open-cy3-matrix-dir -dict=X:V -m=pb -pbc=0  -cutoff=10 -int=-1:200/400 -res=averagey -v=1"
for T in 150 180 250
do
  for A in X A C G T
      do
  for B in A C G T
      do
      ${BIN} ${COMMON} \
      -par=$PREFIX/dna_pb_1020.par,$PREFIX/dna_pb_cy3.par -t=$T \
      -o=open-cy3-${A}-${B}-$T  \
      -seq=${A}${B}TCTTCAGTTCAGCC
      done
done
done
