#!/usr/bin/perl

use strict;

my @list=('epl2011-initial','epl2011-table1','epl2011-69',
          'np2009-1','np2009-2','deoxyinosine_pb','predict-1','predict-2',
          'predict-salt50','open-1','open-cy3','rna-bulges-predict','verify-tna','verify-mm-ci','verify-mm-cd','predict-mm-ci','predict-mm-cd','verify-rna-dna','predict-rna-1',
          'verify-rna-un','verify-rna-ti','verify-rna-ti-salt','verify-rna-un-salt',
          'regression-lna','open-rna-gu','rna-gu-regression','rna-gu-nncheck','verify-terminal-dna','verify-dna-mg','verify-dna-lna-v2','verify-rna-inosine','verify-peg','verify-rna-dna-mm');
          
my $system_id=`lsb-release -d`;

my $bin='tfreg';
my $scriptdir='/usr/share/TfReg/examples';
my $data='/usr/share/TfReg/data';
my $exampledir='/usr/share/TfReg/examples';
my $verifydir='/usr/share/TfReg/examples/verify';
my $rundir="/tmp/tfreg-verify/$ENV{'LOGNAME'}";
my $file_diff_only=0;
my $diff='diff -y';
my $show_identical_files=0;

$bin=$ENV{'TFREGBIN'} if (exists $ENV{'TFREGBIN'});

$verifydir=$ENV{'VERIFYDIR'} if (exists $ENV{'VERIFYDIR'});

$scriptdir=$ENV{'SCRIPTDIR'} if (exists $ENV{'SCRIPTDIR'});

$data=$ENV{'DATADIR'} if (exists $ENV{'DATADIR'});

$rundir=$ENV{'RUNDIR'} if (exists $ENV{'RUNDIR'});

@list=($ENV{'LIST'}) if (exists $ENV{'LIST'});

$file_diff_only=$ENV{'FILEDIFFONLY'} if (exists $ENV{'FILEDIFFONLY'});

$diff=$ENV{'DIFF'} if (exists $ENV{'DIFF'});# eg. export DIFF="wdiff --no-common"

$show_identical_files=$ENV{'SHOWIDENTICALFILES'} if (exists $ENV{'SHOWIDENTICALFILES'});

print "bin=$bin\n";
print "verifydir=$verifydir\n";
print "scriptdir=$scriptdir\n";
print "datadir=$data\n";
print "rundir=$rundir\n";
print "list=",join(',',@list),"\n";

if ($system_id =~ /Ubuntu/)
  {
  my $scriptdir='/usr/share/tfreg/examples';
  my $data='/usr/share/tfreg/data';
  my $exampledir='/usr/share/tfreg/examples';
  my $verifydir='/usr/share/tfreg/examples/verify'; 
  }

if ($ARGV[0] eq 'local')
  {
  $bin='../tfreg';
  $scriptdir='.';
  $data='../data';
  $exampledir='.';
  $verifydir='verify';
  $rundir=".";
  }
else
  {
  system("mkdir -p $rundir");
  }
  
  
my @verification_list;
my @verify_files;
my @run_files;
foreach my $script (@list)
  {
  system("export BIN=$bin;export PREFIX=$data;cd $rundir;$scriptdir/$script.sh") == 0 or die "$script.sh failed: $?" if (not $file_diff_only);
  push(@verify_files,glob("$verifydir/$script*"));
  push(@run_files,glob("$rundir/$script*"));
  if (-d "$verifydir/$script")
    {
    push(@verify_files,glob("$verifydir/$script/*"));
    }
  if (-d "$rundir/$script")
    {
    push(@run_files,glob("$rundir/$script/*"));
    }
  }

foreach my $result (@verify_files)
  {
  my $local_result=$result;
  $local_result =~ s/$verifydir\///g;
  push(@verification_list,"diff -sq $rundir/$local_result $result");#-s, --report-identical-files
  }
 
print "\nNow comparing files, all results should be identical\n";
my $identical=0;
my $differ=0;
my $missing_empty=0;
foreach my $verification (@verification_list)
  {
  my $res=qx/$verification 2>&1/;
  if ($res =~ /identical/)
    {
    print $res if ($show_identical_files);
    $identical++;
    }
  else
    {
    if ($res =~ /No such file or directory/)
      {
      my @f=split(/\s+/,$verification);
      if (-z $f[-1])
        {
        print "Empty: $f[-1]\n";
        $missing_empty++;
        }
      else
        {
        print "Not-empty: $f[-1]\n";
        }
      }
    $differ++ if ($res);
    print "$differ !!",$res ;
    if ($file_diff_only)
      {
      $verification =~ s/diff -q -s/$diff/;
      system($verification);
      }

    }
  }

print "$identical files are identical\n$differ files are different\n";

print "$missing_empty missing files $rundir correspond to empty files in $verifydir\n" if ($missing_empty);
