#!/bin/bash
if [ -z $PREFIX ]; then export PREFIX=../data; fi
if [ -z $BIN ]; then export BIN=tfreg; fi
export COMMON="-cutoff=10 -int=-1:200/400 -m=pb -pbc=0 -pm=2 -t=370 -v=1 -printusedpar=1 "
export NNCHECK="-res=nncheck "
export PRED="-res=prediction -reg=$PREFIX/lna-dna-pb-1021.reg "
export PRED2="-res=prediction -reg=$PREFIX/lna-dna-pb-1021-v2.reg "
export DATA="-dict=W:W,R:R,Z:Z,N:N  -data=$PREFIX/you06.dat,$PREFIX/mctigue04.dat,$PREFIX/fakhfakh15-t1.dat,$PREFIX/fakhfakh15-t2.dat"
export DATA2="-data=$PREFIX/you06-v2.dat,$PREFIX/mctigue04-v2.dat,$PREFIX/fakhfakh15-t1-v2.dat,$PREFIX/fakhfakh15-t2-v2.dat"
export WD=verify-dna-lna
set -e
mkdir -p $WD

${BIN} ${COMMON}  ${NNCHECK} $DATA -o=$WD/dna_lna-nn-check -par=$PREFIX/dna_pb_1020.par,$PREFIX/lna-dna-pb-1021-v2.par 

${BIN} ${COMMON} ${PRED} $DATA -o=$WD/dna_lna -par=$PREFIX/dna_pb_1020.par,$PREFIX/lna-dna-pb-1021-v2.par  

#new notation

${BIN} ${COMMON} ${NNCHECK} $DATA2 -o=$WD/dna_lna-nn-check-v2 -par=$PREFIX/dna_pb_1020.par,$PREFIX/lna-dna-pb-1021-v2.par

${BIN} ${COMMON} ${PRED2} $DATA2 -o=$WD/dna_lna-v2 -par=$PREFIX/dna_pb_1020.par,$PREFIX/lna-dna-pb-1021-v2.par

