// $Id: Quadrature.h 865 2015-04-21 22:41:49Z ge $
/// \file Quadrature.h
/// \brief contains the Quadrature function class
///
/// $Revision: 865 $
/// \author Gerald Weber <gweberbh@gmail.com>
#ifndef GBC_QUADRATURE_H
#define GBC_QUADRATURE_H "$Id: Quadrature.h 865 2015-04-21 22:41:49Z ge $"
#include "Legendre.h"
#include "Trapezoidal.h"
namespace gbc
  {
  template<class _RuleTp=gbc::Legendre<> >
  
  /// \brief Class which calculates integration quadratures from integration weights
  ///
  /// \attention This class needs the GNU Scientific Library (GSL) 
  class Quadrature
    {
    public:
    typedef _RuleTp rule_type;
    typedef typename _RuleTp::vector_type vector_type;
    typedef typename vector_type::value_type value_type;

    rule_type Rule;

  Quadrature(void) : Rule() {};

  inline void adjust(vector_type& x)
    {
    Rule.integration_weights(x.size(),1e-10);
    Rule.adjust_space(x);
    }

  value_type integrate(const vector_type &integrand)
    {
    vector_type result = Rule.weights() * integrand;
    return result.sum();
    
    }

  };
}
#endif
