// $Id: zipbuffer.h 628 2011-08-31 15:42:16Z ge $
/// \file zipbuffer
/// \brief testing read of gziped files
///
/// \author Gerald Weber <gweberbh@gmail.com>
/// $Revision: 628 $
#ifndef ZIPBUFFER_H
#define ZIPBUFFER_H "$Id: zipbuffer.h 628 2011-08-31 15:42:16Z ge $"
#include <fstream>
#include <cstdio>
#include <string>
#include "zlib.h"

namespace gbc  
{
/// filebuffer for handling gziped files transparently
class zipbuffer: public std::filebuf
  {
  protected:
    static const int bufferSize=100;
    static const int putbacksize=40;
    char buffer[bufferSize];
    gzFile zipfile;
  public:
  
    zipbuffer(void);
    zipbuffer(std::string file_name);
    ~zipbuffer(void) {zipclose();}
    void zipopen(std::string file_name);
    void zipclose(void);
    void ziprewind(void);
    bool zipeof(void);
  public:
    virtual std::filebuf::int_type underflow(void);
    virtual std::filebuf::pos_type seekpos(std::filebuf::pos_type pos, std::ios::openmode __mode=std::ios_base::in);
    virtual std::filebuf::pos_type seekoff (std::filebuf::off_type __off, std::ios_base::seekdir __way, std::ios_base::openmode __mode=std::ios_base::in);
    virtual bool is_open(void) {return zipfile!=0;}
    };
}
#endif

