#!/bin/bash
#generates regression files, the same that are in the data folder as 
#deoxyinosine_pb_IX.reg where IX=ia,ic,ig,it,ii
#uses parameters for inosine DOI:10.1016/j.cplett.2015.04.045
if [ -z $PREFIX ]; then export PREFIX=../data; fi
if [ -z $BIN ]; then export BIN=tfreg; fi
for IX in "ia" "ic" "ig" "it" "ii"
do
  $BIN -cutoff=10 -int=-1:200/400 -m=pb -o=deoxyinosine_pb_${IX} \
  -par=$PREFIX/dna_pb_1020.par,$PREFIX/deoxyinosine_pb.par -dict=I:I \
  -pbc=0 -pm=-1 -res=regression -t=370 -v=1 -data=$PREFIX/watkins05${IX}.dat
done
