#!/bin/bash
#uses parameters for DNA-RNA
if [ -z $PREFIX ]; then export PREFIX=../data; fi
if [ -z $BIN ]; then export BIN=tfreg; fi
export WD=verify-rna-dna-mm
mkdir -p $WD

export COMMON=" -expand=dCrG_dCrG -cutoff=10 -int=-1:200/400 -pbc=0 -pm=-1 -t=370 -m=pb "

$BIN $COMMON -res=nncheck \
-data=$PREFIX/sugimoto00-t1.dat,$PREFIX/rna-dna-canonical.dat,$PREFIX/muniz25.dat,$PREFIX/watkins11.dat,$PREFIX/xiang22.dat \
-par=$PREFIX/rna-dna-pb-1000.par,$PREFIX/rna-dna-mm-pb-1000.par -o=$WD/nncheck-rna-dna-mm

$BIN $COMMON -res=regression \
-data=$PREFIX/sugimoto00-t1.dat,$PREFIX/rna-dna-canonical.dat,$PREFIX/muniz25.dat,$PREFIX/watkins11.dat,$PREFIX/xiang22.dat \
-par=$PREFIX/rna-dna-pb-1000.par,$PREFIX/rna-dna-mm-pb-1000.par -o=$WD/verify-rna-dna-mm
