#!/bin/bash
if [ -z $PREFIX ]; then export PREFIX=../data; fi
if [ -z $BIN ]; then export BIN=tfreg; fi
export COMMON="-cutoff=10 -int=-1:200/400 -m=pb -pbc=0 -pm=2 -t=370 -v=1"
export WD=verify-dna-mg
mkdir -p $WD

for SALT in 0.5 1.5 3 10 20 50 125
do
${BIN} ${COMMON} -o=$WD/dna_pb_mg_$SALT -par=$PREFIX/dna_pb_mg_$SALT.par -reg=$PREFIX/dna_pb_mg_$SALT.reg \
-res=sprediction -data=$PREFIX/owczarzy12-Mg-$SALT.dat
done

for SALT in 0.5 1.5 3 10 20
do
${BIN} ${COMMON} -o=$WD/dna_pb_mgk_$SALT -par=$PREFIX/dna_pb_mgk_$SALT.par  -reg=$PREFIX/dna_pb_mgk_$SALT.reg  \
-res=sprediction -data=$PREFIX/owczarzy12-MgK-$SALT.dat
done
