#include <cstdlib>
#include <sys/resource.h>
#include <sys/times.h>
#include <iostream>

void print_cpu(void) 
  {
  struct rusage usage;
  getrusage(RUSAGE_SELF, &usage);
  std::cout << "CPU user   : " << usage.ru_utime.tv_sec << "." << usage.ru_utime.tv_usec << "s" << std::endl;
  std::cout << "CPU system : " << usage.ru_stime.tv_sec << "." << usage.ru_stime.tv_usec << "s" << std::endl;
  long mem=usage.ru_maxrss;
  std::string dsc("KB");
  std::cout << "Memory     : " << mem << dsc;
  if (mem > 1024) {mem /= 1024; dsc="MB"; std::cout << " (" << mem << dsc << ")";}
  if (mem > 1024) {mem /= 1024; dsc="GB"; std::cout << " [" << mem << dsc << "]";}
  std::cout  << std::endl;
  }  
  
