// $Id: SequencePosition.h 628 2011-08-31 15:42:16Z ge $
/// \file SequencePosition.h
/// \brief Defines SequencePosition class
///
/// $Revision: 628 $
/// \author Gerald Weber <gweberbh@gmail.com>
#ifndef SEQUENCEPOSITION_H
#define SEQUENCEPOSITION_H "$Id: SequencePosition.h 628 2011-08-31 15:42:16Z ge $"
#include <string>
#include <iostream>


namespace gbc {

typedef  long unsigned int nucleotide_position_type; ///< the type by which we store Nucleotide positions.

/// \brief Stores the  stream and relative position of a Nucleotide
class SequencePosition
  {
  public:
    std::streampos Stream_position;               ///< Position in the file stream.
    nucleotide_position_type Nucleotide_position; ///< Actual position of the Nucleotide in the sequence.
    std::string Contig_description;               ///< contig description string for Fasta format

    /// \brief Resets the values of the member objects to zero (or equivalent).
    void reset(void)
      {
      Stream_position=static_cast<std::streampos>(0);
      Nucleotide_position=0;
      Contig_description=std::string();
      }

    SequencePosition()
      {
      reset();
      }

   /// \brief Sets the description of the contig.
   ///
   /// In Fasta format these are lines begining with '>'.
   void contig_description(const std::string &dsc) {Contig_description=dsc;}

  /// \brief Gets the description of the contig.
  std::string contig_description(void) {return Contig_description;}

  /// \brief Inserts the stream position
  void stream_position(const std::streampos &sp) {Stream_position=sp;}

  /// \brief Gets the stream position
  std::streampos stream_position(void) {return Stream_position;}

  /// \brief Increments Nucleotide_position by one.
  SequencePosition& operator++(void)
    {
    Nucleotide_position++;
    return *this;
    }

  /// \deprecated Use contig_description(string contigid) instead.
  void  setContig(std::string contigid) {contig_description(contigid);}

  /// \deprecated Use contig_description() instead.
  std::string  getContig() {return contig_description();};

  /// \deprecated Set Stream_position directly.
  void setOffset(std::streampos position_in){Stream_position=position_in;}

  /// \deprecated Get Stream_position directly.
  int getOffset(){return Stream_position;}

};
};

#endif
