#!/bin/bash
if [ -z $PREFIX ]; then export PREFIX=../data; fi
if [ -z $BIN ]; then export BIN=tfreg; fi
export WD=verify-rna-inosine
mkdir -p $WD
set -e

export COMM="-duplextype=RNA -dict=I:I -cutoff=10 -int=-1:200/400 -pbc=0 -t=370 -m=pb -res=regression -par=$PREFIX/rna_pb.par,$PREFIX/inosine_pb.par"

$BIN -$COMM -pm=2 -data=$PREFIX/inosine-iu.dat  -o=$WD/verify-rna-inosine-iu
$BIN -$COMM -pm=2 -data=$PREFIX/inosine-ic.dat  -o=$WD/verify-rna-inosine-ic
$BIN -$COMM -pm=-1 -data=$PREFIX/inosine-tandem-ic.dat  -o=$WD/verify-rna-inosine-tandem-ic
$BIN -$COMM -pm=2 -data=$PREFIX/inosine-ig.dat  -o=$WD/verify-rna-inosine-ig

export COMM="-duplextype=RNA -dict=I:I -cutoff=10 -int=-1:200/400 -pbc=0 -t=370 -m=pb -res=nncheck -par=$PREFIX/rna_pb.par,$PREFIX/inosine_pb.par"

$BIN -$COMM -pm=2 -data=$PREFIX/inosine-iu.dat  -o=$WD/verify-rna-inosine-iu
$BIN -$COMM -pm=2 -data=$PREFIX/inosine-ic.dat  -o=$WD/verify-rna-inosine-ic
$BIN -$COMM -pm=-1 -data=$PREFIX/inosine-tandem-ic.dat  -o=$WD/verify-rna-inosine-tandem-ic
$BIN -$COMM -pm=2 -data=$PREFIX/inosine-ig.dat  -o=$WD/verify-rna-inosine-ig
