// $Id: Trapezoidal.h 865 2015-04-21 22:41:49Z ge $
/// \file Trapezoidal.h
/// \brief contains the Trapezoidal function class
///
/// $Revision: 865 $
/// \author Gerald Weber <gweberbh@gmail.com>
#ifndef GBC_TRAPEZOIDAL_H
#define GBC_TRAPEZOIDAL_H "$Id: Trapezoidal.h 865 2015-04-21 22:41:49Z ge $"
namespace gbc
  {
  template<class _VectorTp  =std::valarray<double> >
  
  /// \brief Class which calculates Trapezoidal rule integration weights
  ///
  /// The trapedoizal integration rule is the worst possible. This class is 
  /// mainly intended for testing.
  class Trapezoidal
    {
    public:
    typedef typename _VectorTp::value_type value_type;
    typedef _VectorTp vector_type;

    vector_type Weights;        ///< Calculated or loaded integration weigths.
    value_type Scale_weights;   ///< Number by which the weights need to be scaled

    Trapezoidal(std::string ignored=std::string()): Scale_weights(1.0) {};

    inline vector_type weights(void)
      {
      vector_type w=Scale_weights * Weights;
      return w;
      }

    /// \brief Calculation of integration weights.
    inline vector_type integration_weights(int steps,        ///< number of integration steps 
                                           value_type limit=0.0) ///< limit, not used, maintained only for compatibility
      {
      value_type h=1.0/steps;
      Weights.resize(steps);
      Weights=h;
      Weights[0]=0.5*h;
      Weights[steps-1]=0.5*h;
      return Weights;
      }

    /// \brief This does not actually adjust any space, only scales the integration step.
    inline void adjust_space(const vector_type& x)
      {
      Scale_weights = (x[x.size()-1]-x[0]);
      }
  };
}
#endif
