#!/bin/bash
#generates regression files, the same that are in the data folder as 
#rna_pb_bulge_group1_*.reg
#uses parameters for type I RNA bulges DOI:10.1063/1.5006948
if [ -z $PREFIX ]; then export PREFIX=../data; fi
if [ -z $BIN ]; then export BIN=tfreg; fi
for BLG in "adenosine" "cytosine" "guanosine" "uridine"
do
  $BIN -cutoff=10 -int=-1:200/400 -m=pb -o=rna-bulges-predict-${BLG} -duplextype=RNA \
  -par=$PREFIX/rna_pb.par,$PREFIX/rna_pb_bulge_group1.par -dict=X:X \
  -pbc=0 -pm=-1 -res=regression -t=370 -v=1 -data=$PREFIX/rna_bulge_group1_${BLG}_adj200.dat
done
