// $Id: ContigDescription.h 628 2011-08-31 15:42:16Z ge $
/// \file ContigDescription.h
/// \brief Defines ContigDescription class
///
/// $Revision: 628 $
/// \author Gerald Weber <gweberbh@gmail.com>
#ifndef CONTIGDESCRIPTION_H
#define CONTIGDESCRIPTION_H "$Id: ContigDescription.h 628 2011-08-31 15:42:16Z ge $"
#include <string>
#include <iostream>
#include <deque>
#include <algorithm>
#include <iterator>
#include "StreamSection.h"
#include "ContigSection.h"
namespace gbc  {

  /// \brief Stores the description of a contig.
  ///
  /// The contig sections that of a Fasta file or the CDS regions of a genbank file.
  ///
  class ContigDescription
    {
    public:
      typedef std::deque<std::string> description_container_type;
      StreamSection Stream_section ;                       ///< Section of the file where the contig is located.
      ContigSection Contig_section ;                       ///< Sequence section where the contig is located.
      bool Complementary;                                  ///< Flag if the contig is located on the complementary strand.
      bool Ignore;                                         ///< Flag which tells us if this contig should be ignored or not in next readings.
      bool Print_short;                                    ///< Flag to print out only first line of description;
      std::string Contig_type;                             ///< Types of contigs we may have.
      description_container_type Description;                 ///< The contig description.
      int Join;                                            ///< If the contig is splitted into several regions, Join will tell us to which region the current contig belongs.

      /// The void constructor.
      ContigDescription(void)
        {
        Description.clear();
	Description.push_back(std::string());
	Complementary=false;
	Ignore=false;
        Contig_type=std::string();
	Print_short=true;
	Join=0;
	}

      /// Sets the description of the contig.
      inline void description(const std::string &st) {Description.front()=st;}

      /// Sets the description of the contig.
      inline void next_description(const std::string &st) {Description.push_back(st);}

      /// Gets the description of the contig.
      inline std::string description(void) const {return Description.front();}

      /// Returns the value of the Ignore field
      friend bool ignore_cd(ContigDescription &cd);

      // Operator for use with list::sort function in ContigTable
      inline bool operator<(ContigDescription &cd)
        {
	return Contig_section < cd.Contig_section;
	}

      /// Extractor which prints the whole description.
     friend std::ostream& operator<<(std::ostream &out, const ContigDescription &cd);

     /// Inserter which gets the whole description for one contig.
     /*friend std::istream& operator>>(std::istream &in, ContigDescription &cd)
       {
       in << cd.Description;
       << endl << cd.Stream_section << " " << cd.Contig_section << endl;
       return out;
       }*/
     };
};

#endif
