#!/usr/bin/perl
#Generates new regression files for different salt concentrations
use strict;
use List::Util qw(first max maxstr min minstr reduce shuffle sum);;

sub S2
  {
  my $x=$_[0];
  my $y=$x;
  $y=$_[1] if (exists $_[1]);
  my $S2=0;
  for(my $i=0; $i < scalar(@$x); $i++) {$S2 += $x->[$i]*$y->[$i];}
  return $S2;
  }
#http://en.wikipedia.org/wiki/Simple_linear_regression
sub linear_regression
  {
  my $x=$_[0];
  my $y=$_[1];
  die "linear_regression: arrays are of different size" if (scalar(@$x) != scalar(@$y));
  my $Sx=sum(@{$x});
  my $Sy=sum(@{$y});
  my $Sxx=S2($x);
  my $Syy=S2($y);
  my $Sxy=S2($x,$y);
  my $n=scalar(@$x);
  my $Delta=$n*$Sxx-$Sx**2;
  my $a=($Sxx*$Sy-$Sx*$Sxy)/$Delta;
  my $b=($n*$Sxy-$Sx*$Sy)/$Delta;
  return ($a,$b);
  }

my $newsalt=$ARGV[0];
my $regfiles=$ARGV[1];

my @files=split(',',$regfiles);

my %reg;
my %a;
my %b;
my $thermal_equivalence_expoent;
my $N_expoent;
my $Species_concentration;
foreach my $file (@files)
  {
  open(FL,$file) or die "Could not open $file";
  my $line=<FL>;
  $line =~ /^(.*)\s(.*)\s(.*)$/;
  $thermal_equivalence_expoent=$1;
  $N_expoent=$2;
  $Species_concentration=$3;
  while ($line=<FL>)
    {
    chomp($line);
    if ($line =~ /^b/)
      {
      $line=<FL>; chomp($line);
      my @f=split(/\s/,$line);
      my $current_salt=log($f[0])/log(10);
      $b{$current_salt}[0][0]=$f[1];
      $b{$current_salt}[0][1]=$f[2];
      $b{$current_salt}[1][0]=$f[3];
      $b{$current_salt}[1][1]=$f[4];
      print "$file $current_salt\n";
      }
    if ($line =~ /^a/)
      {
      $line=<FL>; chomp($line);
      my $current_salt=$line;
      while ($line=<FL>)
        {
        chomp($line);
        my @f=split(/\s/,$line);
        my $current_length=$f[0];
        $a{$current_length}{$current_salt}[0]=$f[1];
        $a{$current_length}{$current_salt}[1]=$f[2];
        }
      }
    }
  close(FL);
  }
  
my @salt_vector;
@salt_vector=sort {$a <=> $b} keys %b;

my @c;
my @nb;
for my $j (0,1)
  {
  for my $k (0,1)
    {
    my @b=();
    for my $current_salt (@salt_vector)
      {
      push(@b,$b{$current_salt}[$j][$k]);
      }
    ($c[0][$j][$k],$c[1][$j][$k])=linear_regression(\@salt_vector,\@b);
    print "j=$j k=$k $c[0][$j][$k] $c[1][$j][$k]\n";
    $nb[$j][$k]=$c[0][$j][$k]+$c[1][$j][$k]*log($newsalt)/log(10);
    }
  }

open(OUT,">$ARGV[2]");
print OUT "$thermal_equivalence_expoent $N_expoent $Species_concentration\n";
print OUT "b\n$newsalt $nb[0][0] $nb[0][1] $nb[1][0] $nb[1][1]\n";

print OUT "a\n$newsalt\n";
foreach my $len (sort {$a <=> $b} keys %a)
  {
  my $a0=$nb[0][0]+$nb[1][0]*sqrt($len);
  my $a1=$nb[0][1]+$nb[1][1]*sqrt($len);
  print OUT "$len $a0 $a1\n";
  }
